import React, {FunctionComponent, ReactNode} from 'react';

import MessageBoxPopup from 'components/MessageBoxPopup/MessageBoxPopup';

import ScopeContext from 'contexts/ScopeContext';

import cx from './Tooltip.scss';

interface ITooltipProps {
    content?: string;
    anchorRef: React.RefObject<HTMLElement>;
    isVisible: boolean;
}

const Tooltip: FunctionComponent<ITooltipProps> = ({
    content,
    anchorRef,
    isVisible,
}) => (
    <ScopeContext.Consumer>
        {(scopeRef): ReactNode => (
            <MessageBoxPopup
                anchorRef={anchorRef}
                scopeRef={scopeRef ? {current: scopeRef} : undefined}
                isVisible={isVisible}
            >
                <div className={cx('content')}>{content}</div>
            </MessageBoxPopup>
        )}
    </ScopeContext.Consumer>
);

export default Tooltip;
