import {FieldMetaState} from 'react-final-form';
import _isObject from 'lodash/isObject';

import {IFieldError} from 'types/common/validation/form';

function isSameValue(value: unknown, prevValue: unknown): boolean {
    if (!value && !prevValue) {
        return true;
    }

    return value === prevValue;
}

export function getStringError(
    error: string | undefined | IFieldError,
    isSubmit: boolean,
): string | undefined {
    if (_isObject(error)) {
        return isSubmit ? error?.submitError : error?.blurError;
    }

    return error;
}

/**
 * Возвращает ошибку из состояния final-form
 */
function getValidationErrorMessage(
    value: unknown,
    meta: FieldMetaState<string>,
): string | undefined {
    const {error, submitError, submitFailed, touched, data = {}} = meta;
    const {lastSubmittedValue, error: dataError} = data;

    const stringBlurError =
        getStringError(error, false) || getStringError(submitError, false);
    const stringSubmitError =
        getStringError(error, true) || getStringError(submitError, true);

    const visibleBlurError = touched && stringBlurError;
    const visibleSubmitError =
        touched &&
        submitFailed &&
        isSameValue(value, lastSubmittedValue) &&
        stringSubmitError;
    const visibleDataError = isSameValue(value, dataError?.value)
        ? dataError?.message
        : undefined;

    return (
        visibleBlurError || visibleSubmitError || visibleDataError || undefined
    );
}

export default getValidationErrorMessage;
