import React, {ReactNode, useEffect, useState} from 'react';
import {Route, RouteComponentProps, RouteProps} from 'react-router-dom';

interface IFrameRoute extends RouteProps {
    skeleton?: React.ReactNode;
}

const FrameRoute: React.FC<IFrameRoute> = ({
    skeleton = null,
    component: Component,
    render,
    ...routeProps
}) => {
    const [isNested, setIsNested] = useState(false);

    useEffect(() => {
        if (window && window !== window.top) {
            setIsNested(true);
        }
    }, []);

    return (
        <Route
            {...routeProps}
            render={(props: RouteComponentProps): ReactNode =>
                isNested ? (
                    <>
                        {Component && <Component {...props} />}
                        {render && render(props)}
                    </>
                ) : (
                    skeleton
                )
            }
        />
    );
};

export default FrameRoute;
