import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {useBoolean} from 'utilities/hooks/useBoolean';

import FullscreenSpinner from './FullscreenSpinner';

export default {
    title: 'Example/FullscreenSpinner',
    component: FullscreenSpinner,
} as Meta;

export const WithFullscreenSpinner: TStorybookFunctionComponent = () => {
    const {value: visible, toggle} = useBoolean(false);

    return (
        <div>
            <button style={{zIndex: Number.MAX_SAFE_INTEGER}} onClick={toggle}>
                {visible ? 'вырубить лоадер' : 'врубить лоадер'}
            </button>
            {visible && <FullscreenSpinner />}
        </div>
    );
};

WithFullscreenSpinner.parameters = {
    info: {
        comment: (
            <>Компонент который отображает фиксед лоадер на всю страницу</>
        ),
    },
};
