import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import Spinner from 'components/Spinner/Spinner';

import cx from './FullscreenSpinner.scss';

interface IFullscreenSpinnerProps extends IWithQaAttributes {}

const FullscreenSpinner: React.FC<IFullscreenSpinnerProps> = props => {
    const deviceType = useDeviceType();

    return (
        <div
            className={cx('root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            <Spinner />
        </div>
    );
};

export default FullscreenSpinner;
