import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {useScrollHiding} from './utilities/useScrollHiding';
import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';

import cx from './Hanging.scss';

interface IHangingProps extends IWithClassName, IWithQaAttributes {
    left?: boolean;
    onClick?: () => void;
}

const Hanging: FunctionComponent<IHangingProps> = ({
    children,
    className,
    left,
    onClick,
    ...qaProps
}) => {
    const isHidden = useScrollHiding();

    return (
        <Flex
            alignItems="center"
            justifyContent="center"
            className={cx('root', className, {
                root_hidden: isHidden,
                root_left: left,
            })}
            onClick={onClick}
            {...qaProps}
        >
            {children}
        </Flex>
    );
};

export default Hanging;
