import React from 'react';
import {useSelector} from 'react-redux';

import {YANDEX_PLUS_URL} from 'constants/urls/plus';

import {IWithClassName} from 'types/withClassName';

import {getUserPlusInfo} from 'selectors/common/userInfoSelector';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Link from 'components/Link/Link';
import PlusColoredLabel from 'components/PlusColoredLabel/PlusColoredLabel';
import YandexPlusSignColorGradientS from 'icons/illustrations/YandexPlusSignColorGradient/YandexPlusSignColorGradientS';
import PlusBadgeM from 'icons/illustrations/PlusBadge/PlusBadgeM';

import cx from './PlusHeaderIcon.scss';

interface IPlusHeaderIconProps extends IWithQaAttributes, IWithClassName {}

const PlusHeaderIcon: React.FC<IPlusHeaderIconProps> = ({
    className,
    ...rest
}) => {
    const {isMobile} = useDeviceType();
    const userPlusInfo = useSelector(getUserPlusInfo);
    const hasPlus = userPlusInfo.hasPlus;

    return (
        <Link
            className={cx('plusLink', className)}
            target="_blank"
            url={YANDEX_PLUS_URL}
            {...prepareQaAttributes(rest)}
        >
            {isMobile && (
                <YandexPlusSignColorGradientS
                    className={cx('plusBadge', 'plusSmall')}
                    width="20"
                    height="20"
                />
            )}
            {hasPlus ? (
                <PlusColoredLabel
                    className={cx('plusBadge', isMobile ? 'plusFull' : null)}
                    count={userPlusInfo.points ?? 0}
                    size="m"
                />
            ) : (
                <PlusBadgeM
                    className={cx('plusBadge', isMobile ? 'plusFull' : null)}
                    height="20"
                    width="48"
                />
            )}
        </Link>
    );
};

export default PlusHeaderIcon;
