import React from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CloseIcon from 'icons/12/Close';
import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';
import WhiteLabelPartnerLogo from 'components/WhiteLabelPartnerLogo/WhiteLabelPartnerLogo';

import cx from './WhiteLabelLogo.scss';

interface IWhiteLabelLogo extends IWithClassName, IWithQaAttributes {
    project?: EProjectName;
}

const DESKTOP_DELIMITER_SIZE = 10;
const MOBILE_DELIMITER_SIZE = 8;

const WhiteLabelLogo: React.FC<IWhiteLabelLogo> = props => {
    const {className, project} = props;
    const deviceType = useDeviceType();
    const delimiterSize = deviceType.isDesktop
        ? DESKTOP_DELIMITER_SIZE
        : MOBILE_DELIMITER_SIZE;

    return (
        <div
            className={cx('root', className)}
            {...prepareQaAttributes({
                parent: props,
                current: 'whiteLabelPortalLogo',
            })}
        >
            <YandexTravelLogo
                withYandexLogo
                isSmall={deviceType.isMobile}
                project={project}
                className={cx('yandexLogo', className)}
            />

            <CloseIcon
                width={delimiterSize}
                height={delimiterSize}
                className={cx('delimiter', deviceMods('delimiter', deviceType))}
            />

            <WhiteLabelPartnerLogo />
        </div>
    );
};

export default React.memo(WhiteLabelLogo);
