import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Heading from './Heading';

export default {
    title: 'Example/Heading',
    component: Heading,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        {[1 as const, 2 as const, 3 as const].map(level => (
            <Heading key={level} level={level}>
                H1 Header
            </Heading>
        ))}
    </>
);
Simple.parameters = {
    info: {
        comment: 'Компоненты стилизует шрифт в соотвествии со спекой',
    },
};
