import {FunctionComponent, ReactNode} from 'react';

import {IWithClassName} from 'types/withClassName';

import cx from './Hint.scss';

export type THintSize = 's' | 'm-inset' | 'm' | 'l' | 'xl';

export interface IHintProps extends IWithClassName {
    // TODO: elyoskin - remove
    massageClassName?: string;
    size?: THintSize;
    message: ReactNode;
    children: ReactNode;
    isAnimated?: boolean;
    isError?: boolean;
}

const Hint: FunctionComponent<IHintProps> = ({
    className,
    massageClassName,
    size = 'm',
    message,
    children,
    isAnimated = true,
    isError = false,
}) => {
    return (
        <div className={cx('root', className)}>
            <div>{children}</div>
            {message && (
                <div
                    className={cx(
                        'hint',
                        {hint_animated: isAnimated},
                        `hint_size_${size}`,
                        {
                            hint_error: isError,
                        },
                        massageClassName,
                    )}
                >
                    {message}
                </div>
            )}
        </div>
    );
};

export default Hint;
