import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import HotelStars from './HotelStars';

export default {
    title: 'Example/HotelStars',
    component: HotelStars,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <HotelStars size="8" stars={5} />
);
Simple.parameters = {
    info: {
        comment: 'Компонент для показа звездности у отеля',
    },
};

const sizes = ['8', '12', '16', '24'] as const;

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={sizes.map(size => ({
            name: size,
            example: <HotelStars size={size} stars={3} />,
        }))}
    />
);
