import {FC, ComponentType} from 'react';

import {IIconProps} from 'icons/types/icon';

import StarIcon8 from 'icons/8/Star';
import StarIcon12 from 'icons/12/Star';
import StarIcon16 from 'icons/16/Star';
import StarIcon24 from 'icons/24/Star';

import cx from './HotelStars.scss';

const icons: Record<string, ComponentType<IIconProps>> = {
    '8': StarIcon8,
    '12': StarIcon12,
    '16': StarIcon16,
    '24': StarIcon24,
};

interface IHotelStarsProps {
    stars?: number;
    size: '8' | '12' | '16' | '24';
}

const HotelStars: FC<IHotelStarsProps> = ({stars, size}) => {
    const Icon = icons[size];

    if (!stars) {
        return null;
    }

    return (
        <span>
            {stars}
            <sup className={cx('iconWrap', `iconWrap_${size}`)}>
                <Icon />
            </sup>
        </span>
    );
};

export default HotelStars;
