import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import HotelIcon from 'icons/16/Hotel';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';

import IconWithRoundBackground from './IconWithRoundBackground';

export default {
    title: 'Example/IconWithRoundBackground',
    component: IconWithRoundBackground,
} as Meta;

export const Themes: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={[
            'label-secondary' as const,
            'control-secondary' as const,
            'primary' as const,
        ].map(theme => ({
            name: theme,
            props: {backgroundColor: theme},
            example: (
                <IconWithRoundBackground
                    icon={<HotelIcon color="#fff" />}
                    backgroundColor={theme}
                />
            ),
        }))}
    />
);
