import {FunctionComponent} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import cx from './ImageIcon.scss';

interface IImageIconProps extends IWithClassName, IWithQaAttributes {
    src: string;
    width?: number | string;
    height?: number | string;
    alt?: string;
}

const ImageIcon: FunctionComponent<IImageIconProps> = props => {
    const {src, alt, className, height, width} = props;

    return (
        <img
            src={src}
            alt={alt}
            className={cx('root', className)}
            style={{width, height}}
            {...prepareQaAttributes(props)}
        />
    );
};

export default ImageIcon;
