import React from 'react';

import {IWithClassName} from 'types/withClassName';
import {
    INewImagesSelectorImage,
    TImagesSelectorImage,
} from './types/IImagesSelectorImage';

import {useFileSelectionDialog} from 'utilities/hooks/useFileSelectionDialog';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import SelectImageTrigger from './components/SelectImageTrigger/SelectImageTrigger';
import SelectedImage from './components/SelectedImage/SelectedImage';

import cx from './ImagesSelector.scss';

interface IImagesSelectorProps extends IWithClassName {
    images: TImagesSelectorImage[];
    onImagesSelected: (newImages: INewImagesSelectorImage[]) => void;
    onDeleteClick: (image: TImagesSelectorImage) => void;
}

const ImagesSelector: React.FC<IImagesSelectorProps> = ({
    className,
    images,
    onImagesSelected,
    onDeleteClick,
}) => {
    const deviceType = useDeviceType();
    const {openFileSelectionDialog} = useFileSelectionDialog(
        files => {
            onImagesSelected(
                files.map(file => ({
                    id: '',
                    name: file.name,
                    file,
                })),
            );
        },
        [onImagesSelected],
    );

    return (
        <div
            className={cx(
                'root',
                deviceMods('root', deviceType),
                {root_grid: images.length},
                className,
            )}
        >
            {images.map(i => (
                <SelectedImage
                    key={`${i.id}_${'name' in i && i.name}`}
                    className={cx('image')}
                    image={i}
                    onDeleteClick={onDeleteClick}
                />
            ))}
            <SelectImageTrigger
                onClick={openFileSelectionDialog}
                isWide={!images.length}
            />
        </div>
    );
};

export default ImagesSelector;
