import _ from 'lodash';
import React, {useMemo} from 'react';

import {getDotSize} from '../utilities/animationHepers';

import NavigationAnimationController from 'components/ImagesSwipeCarousel/components/NavigationAnimationController/NavigationAnimationController';

import cx from './Navigation.scss';

export interface INavigationProps {
    itemsCount: number;
    activeItem: number;
    maxItemsCount: number;
}

const POINT_SIZE = 10;
const NAVIGATION_ITEMS_THRESHOLD = 1;

const Navigation: React.FC<INavigationProps> = ({
    itemsCount,
    activeItem,
    maxItemsCount,
}) => {
    const indices = useMemo(() => _.range(itemsCount), [itemsCount]);

    if (itemsCount <= NAVIGATION_ITEMS_THRESHOLD) {
        return null;
    }

    return (
        <div className={cx('root')}>
            <NavigationAnimationController
                itemsCount={itemsCount}
                activeItem={activeItem}
                maxItemsCount={maxItemsCount}
                pointsSize={POINT_SIZE}
            >
                {indices.map(key => (
                    <div
                        key={key}
                        className={cx(
                            'item',
                            `item_${getDotSize(
                                itemsCount,
                                maxItemsCount,
                                activeItem,
                                key,
                            )}`,
                            {
                                item_active: key === activeItem,
                            },
                        )}
                    />
                ))}
            </NavigationAnimationController>
        </div>
    );
};

export default Navigation;
