import {useRef} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';

import SizeTemplate from './__docs__/SizeTemplate';
import Input from './Input';

export default {
    title: 'Example/Input',
    component: Input,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Box between="3">
        <div>
            <label htmlFor="login">Login</label>
            <Input id="login" name="login" placeholder="Login" />
        </div>
        <div>
            <label htmlFor="password">Password</label>
            <Input
                id="password"
                name="password"
                placeholder="Password"
                type="password"
            />
        </div>
    </Box>
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                size: '32px',
                example: <SizeTemplate size="s" />,
            },
            {
                name: 'm-inset',
                size: '36px',
                example: <SizeTemplate size="m-inset" />,
            },
            {
                name: 'm',
                size: '36px',
                comment: 'по умолчанию',
                example: <SizeTemplate size="m" />,
            },
            {
                name: 'l',
                size: '44px',
                example: <SizeTemplate size="m" />,
            },
        ]}
    />
);

export const ProgramFocus: TStorybookFunctionComponent = () => {
    const ref = useRef<HTMLElement | null>(null);

    return (
        <div>
            <Box below="1">
                <label htmlFor="greeting">Greeting</label>
                <Input
                    id="greeting"
                    inputRef={(input): void => {
                        ref.current = input;
                    }}
                    onKeyDown={(e): void =>
                        e.key === 'Escape' ? ref.current?.blur() : undefined
                    }
                    // или можно использовать target от инпута
                    // onKeyDown={e => e.key === 'Escape' && e.target.blur()}
                />
            </Box>
            <button onClick={(): void => ref.current?.focus()}>Focus</button>
        </div>
    );
};

ProgramFocus.parameters = {
    info: {
        comment:
            'Чтобы программно зафокусить инпут необходимо получить ref от инпута при помощи параметра `inputRef`',
    },
};
