import {FunctionComponent} from 'react';

import {TInputSize} from 'components/Input/types/InputProps';

import Input from 'components/Input/Input';
import Box from 'components/Box/Box';
import Icon from 'icons/16/Search';

interface ISizeTemplateProps {
    size: TInputSize;
}

const SizeTemplate: FunctionComponent<ISizeTemplateProps> = ({size}) => (
    <Box between="1">
        <Input size={size} placeholder="simple input" />
        <Input size={size} iconLeft={<Icon />} placeholder="left icon" />
        <Input size={size} iconRight={<Icon />} placeholder="right icon" />
        <Input size={size} value="with сlear icon" hasClear />
        <Input
            size={size}
            state="error"
            iconLeft={<Icon />}
            placeholder="error"
        />
        <Input
            size={size}
            state="error"
            hint="поле содержит ошибку"
            iconLeft={<Icon />}
            placeholder="error"
        />
        <Input
            size={size}
            disabled
            iconRight={<Icon />}
            placeholder="disabled"
        />
    </Box>
);

export default SizeTemplate;
