import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import Box from 'components/Box/Box';
import Price from 'components/Price/Price';

import InputRange from './InputRange';

import cx from './__docs__/styles.scss';

export default {
    title: 'Example/InputRange',
    component: InputRange,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <Box above="10">
        <InputRange
            className={cx('inputRange')}
            rangeValues={[0, 300]}
            values={[0]}
            hasLeftTrack={true}
            renderHandleTooltip={({value}): ReactNode => (
                <div className="inputRangeHandle">~{value}</div>
            )}
        />
    </Box>
);
Simple.parameters = {
    info: {
        comment:
            'Range Input с одним значением, размер s, позиция тултипа сверху, кастомные стили контента тултипа',
    },
    layout: 'padded',
};

export const Range: TStorybookFunctionComponent = () => (
    <Box above="10">
        <InputRange
            className={cx('inputRangeBottom')}
            rangeValues={[0, 300]}
            values={[150, 300]}
            size="m"
            tooltipPosition="bottom"
            renderHandleTooltip={({value, rangeValues}): ReactNode => (
                <Price
                    className={cx('inputRangePriceHandle')}
                    value={value}
                    postfix={value === rangeValues[1] ? '+' : ''}
                    currency={CurrencyType.RUB}
                />
            )}
        />
    </Box>
);
Range.parameters = {
    info: {
        comment:
            'Range Input с двумя значениями, размер m, позиция тултипа снизу, кастомные стили контента тултипа',
    },
    layout: 'padded',
};

export const Disabled: TStorybookFunctionComponent = () => (
    <InputRange
        className={cx('inputRangeBottom')}
        rangeValues={[0, 300]}
        values={[150, 300]}
        size="m"
        tooltipPosition="bottom"
        disabled
        renderHandleTooltip={({value, rangeValues}): ReactNode => (
            <Price
                className={cx('inputRangePriceHandle')}
                value={value}
                postfix={value === rangeValues[1] ? '+' : ''}
                currency={CurrencyType.RUB}
            />
        )}
    />
);
