import {FunctionComponent} from 'react';
import {RailObject} from 'react-compound-slider';

import {IInputRangeProps} from 'components/InputRange/InputRange';

/* Init Styles */
import cx from './InputRangeRail.scss';

interface IInputRangeRailProps {
    size: IInputRangeProps['size'];
    disabled?: boolean;
    railProps: RailObject;
}

const InputRangeRail: FunctionComponent<IInputRangeRailProps> = ({
    railProps,
    disabled,
    size,
}) => (
    <div
        className={cx('rail', `rail_size_${size}`, disabled && 'rail_disabled')}
        {...railProps.getRailProps()}
    />
);

export default InputRangeRail;
