import {FunctionComponent} from 'react';
import {TrackItem, GetTrackProps} from 'react-compound-slider';

import {IInputRangeProps} from 'components/InputRange/InputRange';

/* Init Styles */
import cx from './InputRangeTrack.scss';

interface IInputRangeTrackProps extends TrackItem {
    getTrackProps: GetTrackProps;
    disabled?: boolean;
    size: IInputRangeProps['size'];
}

const InputRangeTrack: FunctionComponent<IInputRangeTrackProps> = ({
    size,
    source,
    target,
    getTrackProps,
    disabled,
}) => (
    <div
        className={cx(
            'track',
            disabled && 'track_disabled',
            `track_size_${size}`,
        )}
        style={{
            left: `${source.percent}%`,
            width: `${target.percent - source.percent}%`,
        }}
        {...getTrackProps()}
    />
);

export default InputRangeTrack;
