import React, {useMemo} from 'react';

import {IInputProps} from 'components/Input/types/InputProps';

import Input from 'components/Input/Input';
import CheckIcon from 'icons/16/Check';
import Spinner from 'components/Spinner/Spinner';

import cx from './InputWithLoader.scss';

export enum EInputLoadingStatus {
    LOADING = 'LOADING',
    DONE = 'DONE',
    DEFAULT = 'DEFAULT',
}

interface IInputWithLoaderProps extends IInputProps {
    loading: EInputLoadingStatus;
}

const InputWithLoader: React.FC<IInputWithLoaderProps> = ({
    loading,
    ...props
}) => {
    const inputIcon = useMemo((): React.ReactElement | undefined => {
        switch (loading) {
            case EInputLoadingStatus.DONE:
                return <CheckIcon className={cx('done')} />;
            case EInputLoadingStatus.LOADING:
                return <Spinner size="xxs" />;
            case EInputLoadingStatus.DEFAULT:
            default:
                return undefined;
        }
    }, [loading]);

    return <Input {...props} iconRight={inputIcon} />;
};

export default InputWithLoader;
