import {FunctionComponent} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import StyleguidistSizeTable from 'components/StyleguidistSizeTable/StyleguidistSizeTable';
import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';
import StarIcon from 'icons/12/Star';

import Label, {ELabelThemeType, ECornersType, TLabelSizeType} from './Label';

export default {
    title: 'Example/Label',
    component: Label,
} as Meta;

const THEMES = Object.values(ELabelThemeType);
const CORNERS = Object.values(ECornersType);

export const Themes: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={THEMES.map(theme => ({
            name: theme,
            props: {theme},
            example: (
                <Label key={theme} size="s" theme={theme}>
                    Низкая цена
                </Label>
            ),
        }))}
    />
);

export const Corners: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={CORNERS.map(corner => ({
            name: corner,
            props: {corner},
            example: (
                <Label key={corner} size="s" cornersType={corner}>
                    Низкая цена
                </Label>
            ),
        }))}
    />
);

const SizeExample: FunctionComponent<{size: TLabelSizeType}> = ({size}) => (
    <Box inline between="1">
        <Label size={size} theme={ELabelThemeType.PRIMARY}>
            Низкая цена
        </Label>
        <Label size={size} iconLeft={StarIcon} theme={ELabelThemeType.PRIMARY}>
            Низкая цена
        </Label>
    </Box>
);

export const Sizes: TStorybookFunctionComponent = () => (
    <StyleguidistSizeTable
        sizes={[
            {
                name: 's',
                size: '18px',
                example: <SizeExample size="s" />,
            },
            {
                name: 's-inset',
                size: '18px',
                example: <SizeExample size="s-inset" />,
            },
            {
                name: 'm',
                size: '20px',
                example: <SizeExample size="m" />,
            },
            {
                name: 'm-inset',
                size: '20px',
                example: <SizeExample size="m-inset" />,
            },
        ]}
    />
);
