import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import BookingLayout from './BookingLayout';

export default {
    title: 'Example/Layout/BookingLayout',
    component: BookingLayout,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <DeviceTypeContext.Consumer>
        {(deviceType): ReactNode => (
            <BookingLayout
                deviceType={deviceType}
                leftColumn={
                    <>
                        <BookingLayout.Snippets>
                            <BookingLayout.Card>
                                <div style={{backgroundColor: '#E6E6E6'}}>
                                    Москва - Владивосток. Недорого.
                                </div>
                            </BookingLayout.Card>
                            <BookingLayout.Card>
                                <div style={{backgroundColor: '#E6E6E6'}}>
                                    Владивосток - Москва. Дорого.
                                </div>
                            </BookingLayout.Card>
                        </BookingLayout.Snippets>
                        <BookingLayout.Forms>
                            <BookingLayout.Card sectioned>
                                <CardWithDeviceLayout.Section>
                                    <div
                                        style={{
                                            height: 154,
                                            backgroundColor: '#E6E6E6',
                                        }}
                                    >
                                        Пассажир1
                                    </div>
                                </CardWithDeviceLayout.Section>
                                <CardWithDeviceLayout.Section>
                                    <div
                                        style={{
                                            height: 154,
                                            backgroundColor: '#E6E6E6',
                                        }}
                                    >
                                        Пассажир2
                                    </div>
                                </CardWithDeviceLayout.Section>
                            </BookingLayout.Card>
                            <BookingLayout.Card>
                                <div
                                    style={{
                                        width: '100%',
                                        height: 154,
                                        backgroundColor: '#E6E6E6',
                                    }}
                                >
                                    Контакты
                                </div>
                            </BookingLayout.Card>
                        </BookingLayout.Forms>
                    </>
                }
                rightColumn={
                    <BookingLayout.Cart>
                        <div
                            style={{
                                width: '100%',
                                height: 600,
                                backgroundColor: '#E6E6E6',
                            }}
                        >
                            Корзинка
                        </div>
                    </BookingLayout.Cart>
                }
            />
        )}
    </DeviceTypeContext.Consumer>
);
