import {FunctionComponent, ReactNode} from 'react';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import CommonBreadcrumbs from 'components/Breadcrumbs/Breadcrumbs';
import SupportItem from './components/SupportItem/SupportItem';
import Container from 'components/Layouts/Container/Container';

import cx from './Breadcrumbs.scss';

interface IBreadcrumbsProps extends IWithQaAttributes {
    children: ReactNode;
    additional?: ReactNode;
}

interface IStaticProps {
    Item: typeof CommonBreadcrumbs.Item;
    SupportItem: typeof SupportItem;
}

const Breadcrumbs: FunctionComponent<IBreadcrumbsProps> & IStaticProps =
    props => {
        const {children, additional} = props;
        const deviceType = useDeviceType();
        const {isMobile} = deviceType;

        return (
            <Container>
                <CommonBreadcrumbs
                    className={cx('root', deviceMods('root', deviceType))}
                    additional={additional}
                    x={isMobile ? 4 : 5}
                    hasBorder
                    {...prepareQaAttributes(props)}
                >
                    {children}
                </CommonBreadcrumbs>
            </Container>
        );
    };

Breadcrumbs.Item = CommonBreadcrumbs.Item;
Breadcrumbs.SupportItem = SupportItem;

export default Breadcrumbs;
