import {FunctionComponent} from 'react';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box, {IBoxProps} from 'components/Box/Box';

interface ISnippetsProps extends Pick<IBoxProps, 'below'> {}

const Snippets: FunctionComponent<ISnippetsProps> = ({children, below = 5}) => {
    const {isMobile} = useDeviceType();

    return (
        <Box between={isMobile ? 2 : 3} below={below}>
            {children}
        </Box>
    );
};

export default Snippets;
