import {FunctionComponent, ReactElement} from 'react';
import {Sticky} from 'react-sticky';

import Box from 'components/Box/Box';

export interface IStickyStyledComponentProps {
    zIndex?: number;
}

const StickyStyledComponent: FunctionComponent<IStickyStyledComponentProps> = ({
    children,
    zIndex,
}) => (
    <Sticky>
        {({style}): ReactElement => (
            <div style={{...style, zIndex}}>
                <Box between="5">{children}</Box>
            </div>
        )}
    </Sticky>
);

export default StickyStyledComponent;
