import React, {useRef} from 'react';

import {IWithClassName} from 'types/withClassName';

import {deviceModMobile} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import ScopeContext from 'contexts/ScopeContext';

import cx from './Container.scss';

export interface IContainerProps extends IWithClassName {
    /**
     * Помогает заскоупить попапы под шапкой и другими плавающими элементами.
     * Старые попапы, спозиционированные со сдвигами могут при этом съехать, поэтому по умолчанию выключено.
     */
    provideScope?: boolean;
}

const Container: React.FC<IContainerProps> = ({
    className,
    provideScope,
    children,
}) => {
    const containerRef = useRef<HTMLDivElement>(null);

    return (
        <div
            className={cx(
                'root',
                deviceModMobile('root', useDeviceType()),
                className,
            )}
            ref={containerRef}
        >
            {provideScope ? (
                <ScopeContext.Provider
                    value={containerRef.current || undefined}
                >
                    {children}
                </ScopeContext.Provider>
            ) : (
                children
            )}
        </div>
    );
};

Container.displayName = 'Container';

export default Container;
