import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {EProjectName} from 'constants/common';

import {TStorybookFunctionComponent} from 'storybook/types';
import {EFooterProject} from 'components/Footer/types';

import HappyPageContent from '../../../projects/happyPage/components/HappyPageContent/HappyPageContent';

import HappyPageLayout from './HappyPageLayout';

export default {
    title: 'Example/Layout/HappyPageLayout',
    component: HappyPageLayout,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <>
        <style>
            {`
            .content {
                background: #E6E6E6;
                height: 100px;
            }
            `}
        </style>
        <HappyPageLayout
            orderType={EProjectName.TRAINS}
            footerType={EFooterProject.TRAINS}
        >
            <HappyPageContent
                orderType={EProjectName.TRAINS}
                orderHeaderInfo={<div className="content">OrderHeaderInfo</div>}
                orderInfo={<div className="content">OrderInfo</div>}
                orderActions={<div className="content">OrderActions</div>}
                crossSale={{blocks: []}}
                prettyOrderId="YA-2815-7973-8968"
                email="test-email@yandex.ru"
            />
        </HappyPageLayout>
    </>
);

export const Loading: TStorybookFunctionComponent = () => (
    <HappyPageLayout
        orderType={EProjectName.TRAINS}
        footerType={EFooterProject.TRAINS}
        isLoading
    />
);
