import React, {useMemo} from 'react';

import {EFooterProject} from 'components/Footer/types';
import {IWithClassName} from 'types/withClassName';
import EHeaderBorderBottomType from 'components/Header/types/EHeaderBorderBottomType';
import TOrderType from 'types/common/orders/TOrderType';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import * as i18nBlock from 'i18n/happyPage';

import LayoutDefault, {
    ELayoutBgColor,
} from 'components/Layouts/LayoutDefault/LayoutDefault';
import BookLoader from 'components/BookLoader/BookLoader';

import cx from './HappyPageLayout.scss';

interface IHappyPageLayoutProps extends IWithClassName {
    orderType: TOrderType;
    footerType: EFooterProject;
    isLoading?: boolean;
    error?: React.ReactNode;
    children?: React.ReactNode;
}

const HappyPageLayout: React.FC<IHappyPageLayoutProps> = props => {
    const {className, orderType, footerType, isLoading, error, children} =
        props;

    const deviceType = useDeviceType();

    const content = useMemo(() => {
        if (isLoading) {
            return (
                <BookLoader
                    title={i18nBlock.loaderTitle()}
                    description={i18nBlock.loaderDescription()}
                    isLoading
                />
            );
        }

        if (error) {
            return error;
        }

        return children;
    }, [isLoading, error, children]);

    return (
        <LayoutDefault
            className={cx('root', deviceMods('root', deviceType), className)}
            contentClassName={cx('content', {content_loading: isLoading})}
            footerClassName={cx('footer')}
            project={orderType}
            footerType={footerType}
            isFixedNavigation
            showNavigation
            hasSideSheetNavigation
            headerBorderBottomType={EHeaderBorderBottomType.NONE}
            footerIncludeSupportBlock
            bgColor={
                deviceType.isMobile ? ELayoutBgColor.DARK : ELayoutBgColor.LIGHT
            }
        >
            {content}
        </LayoutDefault>
    );
};

export default React.memo(HappyPageLayout);
