import {FC, memo} from 'react';

import TOrderType from 'types/common/orders/TOrderType';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Flex from 'components/Flex/Flex';
import DesktopSupportPhone from 'projects/trips/components/DesktopSupportPhone/DesktopSupportPhone';
import OrderId from 'components/Layouts/HappyPageLayout/components/OrderId/OrderId';
import SuccessText from 'components/Layouts/HappyPageLayout/components/SuccessText/SuccessText';
import SuccessImage from 'components/Layouts/HappyPageLayout/components/SuccessImage/SuccessImage';

import cx from './DesktopOrderHeader.scss';

interface IOrderHeaderProps extends IWithQaAttributes {
    orderType: TOrderType;
    prettyOrderId: string;
    email: string;
    title?: string;
}

const DesktopOrderHeader: FC<IOrderHeaderProps> = props => {
    const {orderType, prettyOrderId, email, title} = props;

    return (
        <div {...prepareQaAttributes(props)}>
            <Flex
                inline
                alignItems="center"
                justifyContent="space-between"
                flexWrap="nowrap"
                between={5}
            >
                <SuccessText
                    className={cx('successText')}
                    email={email}
                    title={title}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'successText',
                    })}
                />

                <SuccessImage
                    className={cx('successImage')}
                    orderType={orderType}
                />
            </Flex>

            <Flex
                className={cx('idAndBlock')}
                inline
                alignItems="center"
                justifyContent="space-between"
            >
                <OrderId
                    orderType={orderType}
                    prettyOrderId={prettyOrderId}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'orderId',
                    })}
                />

                <DesktopSupportPhone
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'supportPhone',
                    })}
                />
            </Flex>
        </div>
    );
};

export default memo(DesktopOrderHeader);
