import {FC, memo} from 'react';

import TOrderType from 'types/common/orders/TOrderType';
import {IWithClassName} from 'types/withClassName';

import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import * as i18n from 'i18n/happyPage';

import OrderIcon from 'projects/account/components/OrderIcon/OrderIcon';
import Text from 'components/Text/Text';
import Flex from 'components/Flex/Flex';

interface IOrderIdProps extends IWithClassName, IWithQaAttributes {
    orderType: TOrderType;
    prettyOrderId: string;
}

const OrderId: FC<IOrderIdProps> = props => {
    const {className, orderType, prettyOrderId} = props;

    return (
        <Flex
            className={className}
            inline
            alignItems="center"
            between={2}
            {...prepareQaAttributes(props)}
        >
            <OrderIcon type={orderType} />

            <Text>{i18n.orderNumber({number: prettyOrderId})}</Text>
        </Flex>
    );
};

export default memo(OrderId);
