import {FC, memo} from 'react';

import {EProjectName} from 'constants/common';

import {IWithClassName} from 'types/withClassName';
import TOrderType from 'types/common/orders/TOrderType';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import FlightNoCityPhotoS from 'icons/illustrations/FlightNoCityPhoto/FlightNoCityPhotoS';
import FlightNoCityPhotoTransparentS from 'icons/illustrations/FlightNoCityPhotoTransparent/FlightNoCityPhotoTransparentS';
import HotelNoCityPhotoS from 'icons/illustrations/HotelNoCityPhoto/HotelNoCityPhotoS';
import HotelNoCityPhotoTransparentS from 'icons/illustrations/HotelNoCityPhotoTransparent/HotelNoCityPhotoTransparentS';
import TrainBusNoCityPhotoS from 'icons/illustrations/TrainBusNoCityPhoto/TrainBusNoCityPhotoS';
import TrainBusNoCityPhotoTransparentS from 'icons/illustrations/TrainBusNoCityPhotoTransparent/TrainBusNoCityPhotoTransparentS';

interface ISuccessImageProps extends IWithClassName {
    orderType: TOrderType;
}

const SuccessImage: FC<ISuccessImageProps> = props => {
    const {className, orderType} = props;

    const {isMobile} = useDeviceType();

    const AviaImage = isMobile
        ? FlightNoCityPhotoS
        : FlightNoCityPhotoTransparentS;
    const HotelImage = isMobile
        ? HotelNoCityPhotoS
        : HotelNoCityPhotoTransparentS;
    const TrainBusImage = isMobile
        ? TrainBusNoCityPhotoS
        : TrainBusNoCityPhotoTransparentS;

    switch (orderType) {
        case EProjectName.AVIA: {
            return <AviaImage className={className} />;
        }

        case EProjectName.HOTELS: {
            return <HotelImage className={className} />;
        }

        case EProjectName.TRAINS:
        case EProjectName.BUSES: {
            return <TrainBusImage className={className} />;
        }
    }

    return null;
};

export default memo(SuccessImage);
