import React from 'react';

import {deviceMods} from 'utilities/stylesUtils';
import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Container from 'components/Layouts/Container/Container';

import cx from './IndexLayout.scss';

interface IIndexLayoutProps {
    header: React.ReactNode;
    children: React.ReactNode;
    footer: React.ReactNode;
    disclaimers?: React.ReactNode;
    tabBar?: React.ReactNode;
}

const IndexLayout: React.FC<IIndexLayoutProps> = props => {
    const {header, children, footer, disclaimers, tabBar} = props;

    const deviceType = useDeviceType();

    return (
        <div className={cx('root', deviceMods('root', deviceType))}>
            {header}
            <Container className={cx('wrapper')}>
                {children}

                {Boolean(disclaimers) && (
                    <Box className={cx('disclaimers')} between="1">
                        {disclaimers}
                    </Box>
                )}
            </Container>
            {footer}
            {tabBar}
        </div>
    );
};

export default IndexLayout;
