import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import LayoutError500 from './LayoutError500';

export default {
    title: 'Example/Layout/LayoutError500',
    component: LayoutError500,
} as Meta;

function reload(): void {
    document.location.reload();
}

export const Simple: TStorybookFunctionComponent = () => (
    <LayoutError500
        title="Не удалось получить результаты"
        subtitle="Повторите поиск минут через десять"
        action={{
            type: 'button',
            title: 'Обновить',
            handler: reload,
        }}
    />
);
