import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Spinner from 'components/Spinner/Spinner';
import PaymentHeader from './components/PaymentHeader/PaymentHeader';
import PaymentOrderInfo from './components/PaymentOrderInfo/PaymentOrderInfo';
import DefaultPaymentHeader from 'components/Layouts/NewPaymentLayout/components/DefaultPaymentHeader';

import cx from './PaymentLayout.scss';

export interface IPaymentLayoutProps extends IWithClassName, IWithQaAttributes {
    footer: React.ReactNode;
    orderInfo: React.ReactNode;
    /**
     * Окно оплаты
     */
    children: React.ReactNode;
    /**
     * @default PaymentHeader for desktop
     */
    header?: React.ReactNode;
    loading?: boolean;
    spinnerText?: string;
}

interface IStaticProps {
    PaymentHeader: typeof PaymentHeader;
    PaymentOrderInfo: typeof PaymentOrderInfo;
}

const PaymentLayout: React.FC<IPaymentLayoutProps> & IStaticProps = props => {
    const {
        className,
        header = <DefaultPaymentHeader />,
        footer,
        orderInfo,
        children,
        loading = false,
        spinnerText,
    } = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType), {
                root_loading: loading,
            })}
            {...prepareQaAttributes(props)}
        >
            {header && <div className={cx('header')}>{header}</div>}
            {orderInfo && <div className={cx('orderInfo')}>{orderInfo}</div>}

            <div className={cx('content')}>{children}</div>

            <div
                className={cx('loader')}
                {...prepareQaAttributes({
                    parent: props,
                    current: 'loader',
                })}
            >
                <Spinner size="l" />

                {spinnerText && (
                    <div className={cx('spinnerText')}>{spinnerText}</div>
                )}
            </div>
            <div className={cx('footer')}>{footer}</div>
        </div>
    );
};

PaymentLayout.PaymentHeader = PaymentHeader;
PaymentLayout.PaymentOrderInfo = PaymentOrderInfo;

export default PaymentLayout;
