import React from 'react';

import {IWithClassName} from 'types/withClassName';

import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';
import Separator from 'components/Separator/Separator';
import Avatar from 'components/Layouts/PaymentLayout/components/PaymentHeader/components/Avatar/Avatar';

import cx from './PaymentHeader.scss';

interface IPaymentHeaderProps extends IWithClassName {
    /**
     * @default Avatar
     */
    rightSide?: React.ReactNode;
    /**
     * @default false
     */
    noLogo?: boolean;
}

const PaymentHeader: React.FC<IPaymentHeaderProps> = props => {
    const {className, rightSide = <Avatar />, noLogo = false} = props;

    return (
        <div
            className={cx(className, 'root', {
                root_noLogo: noLogo,
            })}
        >
            {!noLogo && (
                <>
                    <YandexTravelLogo withYandexLogo withoutLinks />
                    <Separator className={cx('separator')} />
                </>
            )}
            <div className={cx('rightSide')}>{rightSide}</div>
        </div>
    );
};

export default PaymentHeader;
