import React, {useEffect} from 'react';

import {IWithClassName} from 'types/withClassName';

import {
    prepareQaAttributes,
    IWithQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';
import handleMount from './utilities/handleMount';

import * as i18nBlock from 'i18n/avia-AviaBooking-BookingTrustLikeSpinner';

import Spinner from 'components/Spinner/Spinner';
import Flex from 'components/Flex/Flex';
import Text from 'components/Text/Text';

import cx from './PaymentFinish.scss';

interface IFinishPayment extends IWithClassName, IWithQaAttributes {
    spinnerText?: string;
    onMount?(): void;
}

const FinishPayment: React.FC<IFinishPayment> = props => {
    const {
        className,
        spinnerText = i18nBlock.waitDashMessage(),
        onMount = handleMount,
    } = props;

    useEffect(() => {
        onMount();
    }, [onMount]);

    return (
        <Flex
            className={cx(className, 'root')}
            flexDirection="column"
            justifyContent="center"
            alignItems="center"
            {...prepareQaAttributes({
                parent: props,
                current: 'loader',
            })}
        >
            <Spinner size="xxl" />

            {spinnerText && (
                <Text className={cx('spinnerText')} size="m">
                    {spinnerText}
                </Text>
            )}
        </Flex>
    );
};

export default FinishPayment;
