import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import CardWithDeviceLayout from 'components/CardWithDeviceLayout/CardWithDeviceLayout';
import Separator from 'components/Separator/Separator';
import Spinner from 'components/Spinner/Spinner';

import cx from './PaymentLayout.scss';

interface IPaymentLayoutProps extends IWithClassName, IWithQaAttributes {
    header: React.ReactNode;
    footer: React.ReactNode;
    orderInfo: React.ReactNode;
    /** Окно оплаты */
    loading?: boolean;
    spinnerText?: string;
}

const PaymentLayout: React.FC<IPaymentLayoutProps> = props => {
    const {
        className,
        header,
        footer,
        orderInfo,
        children,
        loading = false,
        spinnerText,
    } = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType), {
                root_loading: loading,
            })}
            {...prepareQaAttributes(props)}
        >
            <div className={cx('header')}>{header}</div>
            <CardWithDeviceLayout sectioned>
                {orderInfo && (
                    <CardWithDeviceLayout.Section className={cx('orderInfo')}>
                        {orderInfo}
                    </CardWithDeviceLayout.Section>
                )}

                <Separator className={cx('separator')} />

                <div className={cx('content')}>{children}</div>

                <div
                    className={cx('loader')}
                    {...prepareQaAttributes({
                        parent: props,
                        current: 'loader',
                    })}
                >
                    <Spinner size="xxl" />

                    {spinnerText && (
                        <div className={cx('spinnerText')}>{spinnerText}</div>
                    )}
                </div>
            </CardWithDeviceLayout>
            <div className={cx('footer')}>{footer}</div>
        </div>
    );
};

export default PaymentLayout;
