import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';

import * as i18nBlock from 'i18n/components-CheckOrderAuthorization';

import Separator from 'components/Separator/Separator';
import TextSkeleton from 'components/Skeletons/TextSkeleton/TextSkeleton';
import YandexTravelLogo from 'components/YandexTravelLogo/YandexTravelLogo';

import cx from './PaymentHeader.scss';

interface IPaymentHeaderProps extends IWithClassName {
    orderNumber: string | number | undefined;
    withSkeleton?: boolean;
    noLogo?: boolean;
}

const PaymentHeader: React.FC<IPaymentHeaderProps> = props => {
    const {className, withSkeleton, orderNumber = null, noLogo = false} = props;

    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType), {
                root_noLogo: noLogo,
            })}
        >
            {!noLogo && (
                <>
                    <YandexTravelLogo
                        isSmall={deviceType.isMobile}
                        withoutLinks
                    />
                    <Separator className={cx('separator')} />
                </>
            )}
            <div className={cx('orderAndTimer')}>
                {withSkeleton && !orderNumber ? (
                    <TextSkeleton
                        className={cx('orderSkeleton')}
                        withAnimation
                        size="s"
                    />
                ) : (
                    <div className={cx('order')}>
                        {orderNumber &&
                            i18nBlock.orderIdTitle({orderId: orderNumber})}
                    </div>
                )}
            </div>
        </div>
    );
};

export default PaymentHeader;
