import React from 'react';

import {EUserAvatarSize} from 'components/User/types';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {isAuthUser} from 'utilities/userInfo/isAuthUser';
import {useUserInfo} from 'utilities/hooks/useUserInfo';

import UserAvatar from 'components/User/components/AvatarAndLogin/components/Avatar/Avatar';

const Avatar: React.FC = () => {
    const {isMobile} = useDeviceType();
    const userInfo = useUserInfo();

    if (!isAuthUser(userInfo)) {
        return null;
    }

    return (
        <UserAvatar
            avatarPath={userInfo.avatarPath}
            avatarId={userInfo.avatar.default}
            size={isMobile ? EUserAvatarSize.S : EUserAvatarSize.L}
            hasPlus={userInfo.havePlus}
        />
    );
};

export default React.memo(Avatar);
