import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import PaymentOrderInfo from './PaymentOrderInfo';

export default {
    title: 'Example/Layout/Payment/PaymentOrderInfo',
    component: PaymentOrderInfo,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <PaymentOrderInfo
        title="Оплата заказа на сумму 3 600 ₽"
        details={[
            [
                '9 ноября – 10 ноября',
                '9 гостей',
                'Апартаменты Chalet With 5 Bedrooms in Cogollos de Guadix',
            ],
        ]}
        advantages={[
            'Бесплатная отмена до 10 октября 2020',
            'Сопровождаем ваше бронирование до заселения',
        ]}
    />
);
Simple.parameters = {
    info: {
        title: 'Информация о заказе на странице оплаты',
    },
};
