import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';
import {deviceMods} from 'utilities/stylesUtils';
import {
    IWithQaAttributes,
    prepareQaAttributes,
} from 'utilities/qaAttributes/qaAttributes';

import Intersperse from 'components/Intersperse/Intersperse';

import cx from './PaymentDetails.scss';

interface IPaymentDetailsProps extends IWithClassName, IWithQaAttributes {
    children: React.ReactNode;
}

const PaymentDetails: React.FC<IPaymentDetailsProps> = props => {
    const {className, children} = props;
    const deviceType = useDeviceType();

    return (
        <div
            className={cx(className, 'root', deviceMods('root', deviceType))}
            {...prepareQaAttributes(props)}
        >
            <Intersperse separator={<span className={cx('separator')} />}>
                {children}
            </Intersperse>
        </div>
    );
};

export default PaymentDetails;
