import {ReactNode} from 'react';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import DeviceTypeContext from 'contexts/DeviceTypeContext';

import TwoColumnLayout from './TwoColumnLayout';

export default {
    title: 'Example/Layout/TwoColumnLayout',
    component: TwoColumnLayout,
} as Meta;

export const Simple: TStorybookFunctionComponent = () => (
    <DeviceTypeContext.Consumer>
        {(deviceType): ReactNode => (
            <TwoColumnLayout
                deviceType={deviceType}
                rightColumnOffset={10}
                rightColumnWidth={80}
            >
                <TwoColumnLayout.LeftColumn>
                    <div
                        style={{
                            width: '100%',
                            height: 600,
                            backgroundColor: 'gold',
                        }}
                    >
                        <p
                            style={{
                                whiteSpace: 'nowrap',
                                width: '100%',
                                overflow: 'hidden',
                            }}
                        >
                            Очень длинный текст без переносов не растянет
                            колонку - Sed ut perspiciatis unde omnis iste natus
                            error sit voluptatem accusantium doloremque
                            laudantium, totam rem aperiam, eaque ipsa quae ab
                            illo inventore veritatis et quasi architecto beatae
                            vitae dicta sunt explicabo. Nemo enim ipsam
                            voluptatem quia voluptas sit aspernatur aut odit aut
                            fugit, sed quia consequuntur magni dolores eos qui
                            ratione voluptatem sequi nesciunt. Neque porro
                            quisquam est, qui dolorem ipsum quia dolor sit amet,
                            consectetur, adipisci velit, sed quia non numquam
                            eius modi tempora incidunt ut labore et dolore
                            magnam aliquam quaerat voluptatem. Ut enim ad minima
                            veniam, quis nostrum exercitationem ullam corporis
                            suscipit laboriosam, nisi ut aliquid ex ea commodi
                            consequatur? Quis autem vel eum iure reprehenderit
                            qui in ea voluptate velit esse quam nihil molestiae
                            consequatur, vel illum qui dolorem eum fugiat quo
                            voluptas nulla pariatur?
                        </p>
                    </div>
                </TwoColumnLayout.LeftColumn>
                <TwoColumnLayout.RightColumn>
                    <div
                        style={{
                            width: '100%',
                            height: 200,
                            backgroundColor: 'grey',
                        }}
                    />
                </TwoColumnLayout.RightColumn>
            </TwoColumnLayout>
        )}
    </DeviceTypeContext.Consumer>
);
Simple.parameters = {
    info: {
        comment: (
            <>
                Компонента умеет рисовать две колонки на десктопе:
                <ul>
                    <li>левая колонка тянется</li>
                    <li>
                        правая колонка имеет фиксированную ширину и
                        фиксированный отсуп, кратный 4 пикселям.
                    </li>
                </ul>
                На мобильном контент располагается сверху вниз.
                <br />
                Левая колонка занимает свободную ширину, контент не может ее
                растянуть, поэтому контенту можно смело задавать ширину 100%.
            </>
        ),
    },
};

export const PreserveColumnsMobile: TStorybookFunctionComponent = () => (
    <DeviceTypeContext.Consumer>
        {(deviceType): ReactNode => (
            <TwoColumnLayout
                deviceType={deviceType}
                rightColumnOffset={10}
                rightColumnWidth={80}
                preserveColumnsOnMobile
            >
                <TwoColumnLayout.LeftColumn>
                    <div
                        style={{
                            width: '100%',
                            height: 600,
                            backgroundColor: 'gold',
                        }}
                    />
                </TwoColumnLayout.LeftColumn>
                <TwoColumnLayout.RightColumn>
                    <div
                        style={{
                            width: '100%',
                            height: 200,
                            backgroundColor: 'grey',
                        }}
                    />
                </TwoColumnLayout.RightColumn>
            </TwoColumnLayout>
        )}
    </DeviceTypeContext.Consumer>
);
