import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import Box from 'components/Box/Box';
import LazyComponent from 'components/LazyComponent/LazyComponent';

export default {
    title: 'Example/LazyComponent',
    component: LazyComponent,
} as Meta;

export const Common: TStorybookFunctionComponent = () => {
    return (
        <Box between={2}>
            <Box>
                <div
                    style={{
                        background: 'green',
                        height: '150vh',
                        color: 'white',
                        padding: '20px',
                    }}
                >
                    Длинный контент. Скроль вниз.
                </div>

                <LazyComponent
                    renderContent={() => {
                        alert('Рендер тяжелого компонента');

                        return (
                            <div
                                style={{
                                    background: 'red',
                                    height: '100px',
                                    color: 'white',
                                    padding: '20px',
                                }}
                            >
                                Тяжелыйдолговыполняющийсямногопроцессоракушающий
                                компонент
                            </div>
                        );
                    }}
                />
            </Box>
        </Box>
    );
};

export const WithPlaceholder: TStorybookFunctionComponent = () => {
    return (
        <Box between={2}>
            <Box>
                <div
                    style={{
                        background: 'green',
                        height: '150vh',
                        color: 'white',
                        padding: '20px',
                    }}
                >
                    Длинный контент. Скроль вниз.
                </div>

                <LazyComponent
                    renderPlaceholder={ref => {
                        return (
                            <div
                                ref={ref}
                                style={{
                                    background: 'grey',
                                    height: '100px',
                                    color: 'white',
                                    padding: '20px',
                                }}
                            >
                                Заглушка
                            </div>
                        );
                    }}
                    renderContent={() => {
                        alert('Рендер тяжелого компонента');

                        return (
                            <div
                                style={{
                                    background: 'red',
                                    height: '100px',
                                    color: 'white',
                                    padding: '20px',
                                }}
                            >
                                Тяжелыйдолговыполняющийсямногопроцессоракушающий
                                компонент
                            </div>
                        );
                    }}
                />
            </Box>
        </Box>
    );
};
