import {Meta} from '@storybook/react/types-6-0';
import routerDecorator from 'storybook/storyDecorators/routerDecorator';

import {TStorybookFunctionComponent} from 'storybook/types';

import StyleguidistPropTable from 'components/StyleguidistPropTable/StyleguidistPropTable';
import Heading from 'components/Heading/Heading';
import Flex from 'components/Flex/Flex';

import Link, {TLinkThemeType} from './Link';

import cx from './__docs__/styles.scss';

export default {
    title: 'Example/Link',
    component: Link,
    decorators: [routerDecorator],
} as Meta;

const THEMES: TLinkThemeType[] = ['normal', 'black', 'ghost', 'outer', 'brand'];

export const Theme: TStorybookFunctionComponent = () => (
    <StyleguidistPropTable
        props={THEMES.map(theme => ({
            name: theme,
            props: {theme},
            example: (
                <>
                    <Link
                        className={cx(theme === 'outer' && 'bgDark')}
                        theme={theme}
                        text="Find out more"
                        to="/"
                    />

                    <Link
                        className={cx(theme === 'outer' && 'bgDark')}
                        theme={theme}
                        text="Find out more (disabled)"
                        to="/"
                        disabled
                    />
                </>
            ),
        }))}
    />
);

export const External: TStorybookFunctionComponent = () => (
    <Flex flexDirection="column" between={2}>
        <Heading level={3}>
            Если указать пропсу url, то ссылка будет внешней, а не react-router
        </Heading>

        <Link
            theme="normal"
            text="Find out more"
            url="https://travel.yandex.ru"
        />

        <Heading level={3}>Disabled</Heading>

        <Link
            theme="normal"
            text="Find out more"
            url="https://travel.yandex.ru"
            disabled
        />
    </Flex>
);
