import routerDecorator from 'storybook/storyDecorators/routerDecorator';
import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import LinkBreadcrumbs from 'components/LinkBreadcrumbs/LinkBreadcrumbs';

export default {
    title: 'Example/LinkBreadcrumbs',
    component: LinkBreadcrumbs,
    decorators: [routerDecorator],
} as Meta;

export const Simple: TStorybookFunctionComponent = () => {
    return (
        <LinkBreadcrumbs>
            <LinkBreadcrumbs.Item
                title="Москва"
                metaUrl="/msk"
                onClick={(): void => console.log('msk click')}
                to="/msk"
            >
                Москва
            </LinkBreadcrumbs.Item>
            <LinkBreadcrumbs.Item
                title="Химки"
                metaUrl="/himki"
                onClick={(): void => console.log('himki click')}
                to="/himki"
            >
                Химки
            </LinkBreadcrumbs.Item>
            <LinkBreadcrumbs.Item
                title="Двор"
                metaUrl="/dvor"
                onClick={(): void => console.log('dvor click')}
                to="/dvor"
            >
                Двор
            </LinkBreadcrumbs.Item>
        </LinkBreadcrumbs>
    );
};
