import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {IWithQaAttributes} from 'utilities/qaAttributes/qaAttributes';

import Link, {TLinkProps} from 'components/Link/Link';

import cx from './LinkBreadcrumbsItem.scss';

interface IMetaProps {
    /**
     * Специальный пропс, чтобы указать адрес крошке для поисковой разметки
     */
    metaUrl?: string;

    /**
     * Специальный пропс, чтобы указать имя крошке для поисковой разметки
     */
    metaName?: string;
}

interface ILinkBreadcrumbsTextItemProps
    extends IWithClassName,
        IWithQaAttributes,
        IMetaProps {
    children?: React.ReactNode;
}

export type TLinkBreadcrumbsItemProps =
    | (TLinkProps & IMetaProps)
    | ILinkBreadcrumbsTextItemProps;

const LinkBreadcrumbsItem: React.FC<TLinkBreadcrumbsItemProps> = ({
    children,
    className,
    metaName,
    metaUrl,
    ...rest
}) => {
    if (('url' in rest && rest.url) || ('to' in rest && rest.to)) {
        return (
            <Link className={cx(className, 'root')} theme="normal" {...rest}>
                {children}
            </Link>
        );
    }

    return (
        <span className={cx(className, 'root')} {...rest}>
            {children}
        </span>
    );
};

export default LinkBreadcrumbsItem;
