import {Meta} from '@storybook/react/types-6-0';

import {TStorybookFunctionComponent} from 'storybook/types';

import {CurrencyType} from 'utilities/currency/CurrencyType';

import BusIcon from 'icons/16/Bus';
import TrainIcon from 'icons/16/Train';
import PlaneIcon from 'icons/16/Plane';
import {ILinksListItem} from 'components/LinksList/components/LinksListItem';

import LinksList from './LinksList';

export default {
    title: 'Example/LinksList',
    component: LinksList,
} as Meta;

const AVIA_LINK: ILinksListItem = {
    link: {
        url: '/avia',
    },
    text: 'Быриком на самолёте',
    price: {
        value: 4000,
        currency: CurrencyType.RUB,
    },
};

const BUSES_LINK: ILinksListItem = {
    link: {
        url: '/buses',
    },
    text: 'С ветерком на автобусе',
    price: {
        value: 6000,
        currency: CurrencyType.RUB,
    },
};

const TRAINS_LINK: ILinksListItem = {
    link: {
        url: '/trains',
    },
    text: 'Под равномерный стук колёс на поезде',
    price: {
        value: 8500,
        currency: CurrencyType.RUB,
    },
};

export const Links: TStorybookFunctionComponent = () => {
    return (
        <LinksList
            title="Как добраться из Москвы в Сочи?"
            links={[AVIA_LINK, BUSES_LINK, TRAINS_LINK]}
        />
    );
};

export const PriceLinks: TStorybookFunctionComponent = () => {
    return (
        <LinksList
            title="Как добраться из Москвы в Сочи?"
            description="покататься на лыжах, покупаться в море, поесть чурчхелу"
            links={[AVIA_LINK, BUSES_LINK, TRAINS_LINK]}
            priceAsLink
        />
    );
};

export const LinksWithIcons: TStorybookFunctionComponent = () => {
    return (
        <LinksList
            title="Как добраться из Москвы в Сочи?"
            description="покататься на лыжах, покупаться в море, поесть чурчхелу"
            links={[
                {...AVIA_LINK, icon: PlaneIcon},
                {...BUSES_LINK, icon: BusIcon},
                {...TRAINS_LINK, icon: TrainIcon},
            ]}
        />
    );
};

export const PriceLinksWithIcons: TStorybookFunctionComponent = () => {
    return (
        <LinksList
            title="Как добраться из Москвы в Сочи?"
            description="покататься на лыжах, покупаться в море, поесть чурчхелу"
            links={[
                {...AVIA_LINK, icon: PlaneIcon},
                {...BUSES_LINK, icon: BusIcon},
                {...TRAINS_LINK, icon: TrainIcon},
            ]}
            priceAsLink
        />
    );
};
