import React from 'react';

import {IWithClassName} from 'types/withClassName';

import {useDeviceType} from 'utilities/hooks/useDeviceType';

import Box from 'components/Box/Box';
import Heading from 'components/Heading/Heading';
import LinksListItem, {
    ILinksListItem,
} from 'components/LinksList/components/LinksListItem';

import cx from './LinksList.scss';

export interface ILinksListProps extends IWithClassName {
    title: string;
    links: ILinksListItem[];
    description?: string;
    priceAsLink?: boolean;
    onLinkClick?(index: number): void;
}

const LinksList = React.forwardRef<HTMLDivElement, ILinksListProps>(
    function LinkList(props, ref) {
        const {className, title, links, description, priceAsLink, onLinkClick} =
            props;
        const deviceType = useDeviceType();

        return (
            <Box className={className} ref={ref}>
                <Box below={deviceType.isDesktop ? 5 : 4}>
                    <Heading level={2}>{title}</Heading>
                </Box>

                {description && (
                    <Box below={deviceType.isDesktop ? 5 : 4} textSize="m">
                        {description}
                    </Box>
                )}

                <Box className={cx('list')} between="3">
                    {links.map((link, index) => (
                        <LinksListItem
                            key={index}
                            priceAsLink={priceAsLink}
                            onLinkClick={onLinkClick?.bind(null, index)}
                            {...link}
                        />
                    ))}
                </Box>
            </Box>
        );
    },
);

export default LinksList;
